@echo off
setlocal enabledelayedexpansion

if "%~1"=="" (
    echo [#] Usage: %~n0 [enable/disable]
    exit /b 1
)

set "action=%~1"
if /i "%action%"=="enable" (
    set "adminState=enable"
    set "targetState=Disconnected"
	REM echo [#] Enabling all inactive network interfaces...
) else if /i "%action%"=="disable" (
    set "adminState=disable"
    set "targetState=Connected"
	REM echo [#] Disabling all active network interfaces...
) else (
	powershell -Command "Write-Host '[-] Invalid parameter: %action%' -ForegroundColor Red"
    echo [#] Usage: %~n0 [enable/disable]
    exit /b 1
)

for /f "skip=3 tokens=1,2,3,* delims= " %%a in ('netsh interface show interface') do (
    if /i "%%b"=="%targetState%" (
        set "interfaceName=%%d"
        for /f "tokens=* delims= " %%i in ("!interfaceName!") do set "interfaceName=%%i"
        if not "!interfaceName!"=="" (
            netsh interface set interface name="!interfaceName!" admin=%adminState% >nul
            if !errorlevel! equ 0 (
				powershell -Command "Write-Host '[+] Successfully %adminState%d interface: \"!interfaceName!\".' -ForegroundColor Green"
            )
        )
    )
)

REM echo [#] %action% operation finished.